#!/bin/sh

script_dir=$(dirname $0)
script_dir=$(cd $script_dir;pwd)

K_VER=$(uname -r)
. $script_dir/vars $script_dir


while [[ ! -z "$1" ]] ; do
        case $1 in
                *)
                        echo "Unknown option $1"
                        exit
                ;;
        esac
done

if [ -x /usr/voltaire/vlt-iser ] ; then
	iscsi_status=$(/etc/init.d/open-iscsi status)
	echo $iscsi_status | grep -i running >/dev/null
	if [ $? == 0 ] ; then
		echo $iscsi_status
		echo Error : iscsi and iser are active - Uninstall.sh stopped !
		exit 1
	fi
fi 

if [ -x /etc/init.d/gridstack ] ; then
	/etc/init.d/gridstack  stop
fi


if [ -f /etc/SuSE-release ] ; then
        patch  -p1 -R -d /etc/sysconfig/network/scripts/ < /usr/voltaire/functions-ib.diff
fi

if [ -f /etc/redhat-release ] ; then
	grep -v "ifup-pre-ib" /sbin/ifup-pre-local > /tmp/ifup-pre-local
	mv /tmp/ifup-pre-local /sbin/ifup-pre-local
	grep -v "ifdown-post-ib" /sbin/ifdown-pre-local > /tmp/ifdown-pre-local
	mv /tmp/ifdown-pre-local /sbin/ifdown-pre-local
fi

if [ -x /usr/voltaire/vlt-iser/open-iscsi-iser.sh ] ; then
	/usr/voltaire/vlt-iser/open-iscsi-iser.sh -u
fi

rpm -q $VLT_MPI_RPM_NAME
if [ $? -eq 0 ] ; then
	rpm -e $VLT_MPI_RPM_NAME
fi

rpm -q $IB_ENHANCED_SERVICES_RPM_NAME
if [ $? -eq 0 ] ; then
	rpm -e $IB_ENHANCED_SERVICES_RPM_NAME
fi



if [ -x /etc/infiniband/info ] ; then
        ofed_dir=$(/etc/infiniband/info |grep prefix|cut -f2 -d=)
        yes|$ofed_dir/uninstall.sh
fi

grep -v "alias net-pf-27           ib_sdp" /etc/modprobe.conf > /tmp/modprobe.conf
cp /tmp/modprobe.conf /etc/modprobe.conf

if [ -f /lib/modules/$K_VER/source/Module.symvers ] ; then
                MOD_SYMVERS_KERNEL=/lib/modules/$K_VER/source/Module.symvers
        elif [ -f /lib/modules/$K_VER/build/Module.symvers ] ; then
                MOD_SYMVERS_KERNEL=/lib/modules/$K_VER/build/Module.symvers
        else
                echo file Module.symvers not found
fi
if [ ! -z $MOD_SYMVERS_KERNEL ] ; then
	MOD_SYMVERS_PATCH=/usr/voltaire/backup/Module.symvers.patch
	if [ -f $MOD_SYMVERS_PATCH ] ; then
		patch -R -d   $(dirname $MOD_SYMVERS_KERNEL)  < $MOD_SYMVERS_PATCH
	else
		echo $MOD_SYMVERS_PATCH does not exist.
	fi
fi

for wa in /usr/voltaire/workarounds/*.wa  ; do
                echo running workaround $wa
                $wa uninstall
done
rm -rf /usr/voltaire/workarounds/


rm -f $lock_file

